#ifndef CAN_DRIVER_H
#define CAN_DRIVER_H
/*******************************************************************************
*  (c) synertronixx GmbH
*  Vahrenwalder Str. 7
*  30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Project       : CAN-Driver for CAN2Web SCB9328
* Name          : can_driver.h
* Version       : 1.01.1
* Date          : 21.02.2007
* Author        : Blaschke
* *****************************************************************************/

// Linux Header
//#include <linux/time.h>

// error messages
#define CAN_ERR_OK                    0x00  // no error
#define CAN_ERR_XMTFULL               0x01  // CAN-Controller receive buffer full
#define CAN_ERR_OVERRUN               0x02  // CAN-Controller overun
#define CAN_ERR_BUSERROR              0x04  // Bus error: Error counter on limit
#define CAN_ERR_BUSOFF                0x08  // Bus error: CAN-Controller in state 'Bus-Off'
#define CAN_ERR_RECEIVEBUF_OVERFLOW   0x10  // SW-Receive-buffer overflow, CAN-msg. can be lost                                            // overwrite the oldest msg.
#define CAN_ERR_TRANSMITBUF_OVERFLOW  0x20  // SW-Transmit-Buffer overflow, CAN-msg. was not written to transmit buffer

                                
// Error messages for initialisation
#define CAN_INIT_OK            0x00         // initialisation was sucessfully
#define CAN_INIT_ERR_PARAMETER 0x01         // wrong parameter for initialisation
#define CAN_INIT_ERR_HARDWARE  0x02         // SJA1000 not available, hardware error

// size of CAN-IDs
enum TCANMode    {CAN_STANDARD, CAN_EXTENDED}; // use 11 or 29-Bit CAN-msgs.

// ioctl control commands
#define CAN_SET_SETTINGS    1
#define CAN_GET_SETTINGS    2
#define CAN_GET_DRIVER_INFO 3

#define CAN_SET_ON_OFF       20
#define CAN_SET_120OHM       21
#define CAN_SET_FASTMODE     22
#define CAN_SET_AUTO_LED     23
#define CAN_SET_LED          24
#define CAN_SET_HIGHSPEED    25
#define CAN_SET_DEBUGMODE    26

#define CAN_GET_STATE        30
#define CAN_GET_RECEIVE_MSG  31
#define CAN_GET_TRANSMIT_MSG 32



// struct for CAN messages
struct TCANMsg
{
  unsigned long int ID;                    // 11/29 bit identifier
  unsigned char     RTR;                   // TRUE if REMOTE frame
  unsigned char     LEN;                   // Number of valid data bytes (0..8)
  unsigned char     DATA[8];               // Databytes
};

// struct for CAN messages with receive time
struct TCANMsgT
{
  unsigned long int ID;                    // 11/29 bit identifier
  unsigned char     RTR;                   // TRUE if REMOTE frame
  unsigned char     LEN;                   // Number of valid data bytes (0..8)
  unsigned char     DATA[8];               // Databytes
  long              TIMES;                 // receive time seconds 
  long              TIMEUS;                 // receive time micro seconds 
};



// struct for CAN settings
struct CANSettings
{
  unsigned char mode;               // 0 = 11Bit or 1 = 29-Bit CAN messages
  unsigned int  baudrate;           // 5, 10, 20, 50, 100, 125, 250, 500, 1000
  unsigned char baudrate_to_btr;    // 1: set baudrate value to BTR register
                                    // else baudrate is value in KBits/s
  unsigned long int mask;           // CAN-Mask-Register 11/29-Bit message filter
  unsigned long int code;           // CAN-Code-Register 11/29-Bit message filter                                     
};


// struct containing further information about CAN bus driver
#define DRIVER_INFO_STR_SIZE 128
struct DriverInfo
{
  char     version[DRIVER_INFO_STR_SIZE]; // Name, Version, date of CAN driver
  unsigned long int total_rcv;            // total CAN-msgs received since last driver init.
  unsigned long int total_snd;            // total CAN-msgs received since last driver init. 
  unsigned int      rcv_buffer_size;      // size of CAN-msg. receive buffer 
  unsigned int      snd_buffer_size;      // size of CAN-msg. send/transmit buffer 
};




#endif

// End of file
