/*******************************************************************************
*  (c) 2002, synertronixx GmbH
*  Vahrenwalder Str. 7
*  D-30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Name          : com2_test.c
* Version       : 1.06
* Datum         : 19.02.2003
* Autor         : Blaschke
* Beschreibung  : DeviLAN C-Treiber
*                 Beispielprogramm fuer die Verwendung der Treiberroutinen
*                 fuer die serielle Schnittstelle COM2
*                 Es werden N-Zeichenkette ueber die Schnittstelle gesendet
*                 und die eingehenden Daten ausgegangen.
*                 Fuer Testzwecke koennen TxD (Pin 13) und RxD (Pin 15)auf dem
*                 40-pol. Steckverbinder (CON5)mit einem Jumper gebrueckt
*                 werden, so dass die gesendeten Daten wieder empfangen werden.
* Programmaufruf: com3_test [N]  z.B. com2_test 12
* *****************************************************************************/

//Dos-Header
#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>
#include <STDLIB.H>

// DeviLAN-Header
#include "../devilan_106/serial.h"
#include "../devilan_106/intrhndl.h"


/*******************************************************************************
* H A U P T P R O G R A M M
*******************************************************************************/

int main(int argc, char *argv[])
{
   unsigned long int baudrate = 19200L;
   int               databits = db8BITS; // 8 Datenbits, moegliche Werte sind:
                                         //  db5BITS, db6BITS, db7BITS, db8BITS
   int               stopbits = sb2BITS; // 2 Stoppbits, moegliche Werte sind:
                                         //  sb1BITS, sb1HALFBITS, sb2BITS
   int                 parity = ptNONE;  // keine Paritaet, moegliche Werte sind:
                                         //  ptNONE, ptODD, ptEVEN, ptMARK, ptSPACE
   int               flowCtrl = hsNONE;  // kein Handshake, moegliche Werte sind:
                                         //  hsNONE, hsRTSCTS, hsXONXOFF

   char         send_data_block[200];    // Puffer fuer zu sendende Daten
   unsigned int send_length;             // Anzahl der zu sendenden Bytes
   unsigned int bytes_send;              // Anzahl gesendenten BYtes
   char         receive_data_block[200]; // Puffer fuer empfangene Daten
   unsigned int receive_length;          // Anzahl der empfangenen Bytes

   int n=1;                              // Schleifenzaehler
   int N=10;                             // Anzahl der ausgegebenen Zeichenketten
   unsigned char error;                  // Fehlermeldung

   printf("Starte Testprogramm fuer serielle Schnittelle COM2\n\n");
   if (argc==2)
     sscanf(argv[1],"%d",&N);

   DeviLANInit();  // Allgemeine DeviLAN Initialisierungsfunktion
                   // muss zu Beginn des Programms einmal aufgerufen werden

   IPCEnableExternalInterrupts();  // Externe Interrupts freigeben

   error = COM2Init(baudrate, databits, stopbits, parity, flowCtrl);
   if (error!=INITSERIAL_NO_ERROR)
   {
     printf("Fehler bei Initialisierung: %02X\n", error);
     printf("Programm wird abgebrochen!\n");
     exit (0);
   }

   //Hauptschleife
   do
   {
     // Daten senden
     sprintf(send_data_block,"Zeile Nummmer %d\n", n); // Zeichenkette in Puffer
     printf("Gesendet: ");
     printf(send_data_block);

     send_length = strlen(send_data_block);                        // Anzahl der Zeichen ermitteln
     bytes_send = COM2TransmitBlock(send_data_block, send_length); // Senden
     if (bytes_send!=send_length) // Wurden alle Bytes gesendet?
       printf("Fehler: Es wurden nur %d von %d Zeichen ausgegeben!\n\n", bytes_send, send_length);

     // Daten empfangen
     receive_length = COM2ReadBlock(receive_data_block, sizeof(receive_data_block));
     if (receive_length>0)
     {
       printf("Empfangen: ");
       receive_data_block[receive_length]=0; // Nullterminieren
       printf(receive_data_block);
       printf("\n");
     }

     n++;
   }
   while(n<=N);

   COM2Release(); // Wichtig: Alten Interruptvektor wieder herstellen !
                  // COM2Release() muss vor dem Programmende einmal
                  // aufgerufen werden !

   printf("\n\rTestprogramm beendet\n\r");

   return 0;
}


