/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : devilanapprcserver.c
* Version       : see variable "appl_version_info"
* Date          : 15.01.2013
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* *****************************************************************************/

// System header
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <math.h>
#include <sys/time.h>
#include <signal.h>
#include <ctype.h>

#include <sys/select.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// Project header
#include "terminal.h"
#include "socketserver.h"
#include "udpconfig.h"

// gobal variables for main loop
char* appl_name="DeviLAN App RC Server";	        // Application name for debug messages
char* appl_version_info= "Version 1.4 15.01.2013";	// Version information
int  running=1;						                // main loop running

// externals from rcserver.c
extern int timertime;             // actual cycle time for sending commands
extern int debug_traffic;         // marker for debug output

/******************************************************************************
Function:     main
Description:  main for DeviLAN app RC server
Parameter:    none
Return:       0
Date:         09.10.2012
Changes:
******************************************************************************/
int
main (void)
{
	struct timeval next_send_time, actual_time;

    //server variables
	struct sockaddr_in server_addr;
	fd_set read_fd_set;
	int server_socket, client_socket=-1;
	int max_fd_sets;
	socklen_t client_addrlen;
    unsigned char receive_buffer[BUF];

    // insert all termination handler for task (like CRTL-c, etc.)
	InsertTerminationHandler();

	printf("\n\n\n\n%s: start of program '%s'\n", appl_name, appl_version_info);
	usleep(10000);	  // wait for writing string above

    // init keyboard so the program can be controlled by keyboard
    TerminalSetInputMode();	     

    // init all RC server variables
    RCServerInit();              

    // init TCP/IP listen server
    ServerSocketInit(&server_socket, &server_addr, &client_addrlen);

    // init. UDP identification listen server
    UDPInit();                   

    // print infos for keyboard commands
    TerminalPrintKeyboardInfo(); 

    printf("%s: is running\n\n\n", appl_name);
	usleep(10000);	  // wait for writing string above

    // set next sending time for RC server
    gettimeofday(&actual_time, NULL);
    TimeSetTo(&next_send_time, &actual_time, timertime); 

    // main loop
	do
    {	
        // Any UDP broadcast messages ?
        UDPProcessCommands();

        // any TCP/IP connections available ?
		max_fd_sets = ServerLookForConnections( &server_socket, &client_socket, &read_fd_set);

        // process incomming data (when a socket is connected)
		ServerGetMsg(&client_socket, receive_buffer);

    	// get current time
        gettimeofday(&actual_time, NULL);
        if (TimeCompare(&next_send_time, &actual_time)==1)
        { // call send RC server
          RCNextStep(&client_socket);
          TimeSetTo(&next_send_time, &actual_time, timertime); // set next call time 
		}

        // any keyboard inputs
        TerminalHandleKeyboardInputs();
	}
    while (running);

	// shutdown all interfaces and restore settings:

    // restore settings for terminal
    TerminalResetInputMode(); 

    // close TCP client socket 
    if(client_socket != -1)
      close(client_socket);

    // close UDP listener
    UDPClose();

	printf("\n%s: end of program\n\n\n", appl_name);

	return 0;
}

// end of file
