/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : socketserver.c
* Version       : see variable "appl_version_info"
* Date          : 28.09.2012
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* *****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/select.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>

#include <linux/ioctl.h>
#include <sys/ioctl.h>
#include <linux/fs.h>
#include <bits/ioctls.h>

// Project header
#include "socketserver.h"
#include "rcserver.h"
#include "terminal.h"

//
int write_pos=0; // write position in buffer for received data

// externals from devilanapprcserver.c
extern char* appl_name;		    // Application name for debug messages


/******************************************************************************
Function:     ServerSocketInit
Description:  creates an new server socket
Parameter:    sock:        ptr to  server socket
              sockaddr_in: ptr to  server address 
              addr_len:    ptr to address-length
Return:       0 if everything works fine
             -1 otherwise
Date:         28.09.2012
Changes:
******************************************************************************/
int ServerSocketInit(int* sock, struct sockaddr_in * address, socklen_t * addr_len)
{
	int ret=0;
	int y=1;
	int port;
	long save_sock_opt;

	if (!(*sock = socket (PF_INET, SOCK_STREAM, 0)) > 0)
	{
       printf ("%s: Error, Socket couldn't be created\n", appl_name);
	}

	port = DEFAULT_TCPPORT;
	address->sin_family = AF_INET;
	address->sin_addr.s_addr = INADDR_ANY;
	address->sin_port = htons (port);

	setsockopt( *sock, SOL_SOCKET, SO_REUSEADDR, &y, sizeof(int));

	if (bind( *sock, (struct sockaddr *) address, sizeof (*address)) != 0)
	{
		printf("%s: Binding Socket failed\n", appl_name);
		return -1;
	}

	if ( listen (*sock, 5) < 0 )
	{
		printf("%s: Error, listen failed!", appl_name);
		return -1;
	}
	*addr_len = sizeof (struct sockaddr_in);

	save_sock_opt=fcntl (*sock, F_GETFL, 0);
	save_sock_opt|=O_NONBLOCK;
	fcntl (*sock, F_SETFL,save_sock_opt );

	return ret;
}
/******************************************************************************
Function:     ServerSendFirstMsg
Description:  after the first connection, sends the modul type
Parameter:    serversocket, string
Return:       >0: no. of bytes written
              -1 or 0: when write failed
Date:         28.09.2007
Changes:
******************************************************************************/
int ServerSendFirstMsg(int * sock)
{
	char buffer[30]= "modul_typ remote";

    return SendStringToStream(sock, buffer);
}
/******************************************************************************
Function:     ServerSendMsg
Description:  send a string to the socket
Parameter:    socket and string (pointer)
Return:       >0: no. of bytes written
              -1 or 0: when write failed
Date:         28.09.2012
Changes:
******************************************************************************/
int ServerSendMsg(int* socket, char* buffer)
{
	int ret;

	ret = write(*socket, buffer, strlen (buffer) );
	return ret;
}



/******************************************************************************
Function:     ServerGetMsg
Description:  reads out socket data until CR is received and calls data processing function
Parameter:    socket,  string
Return:       the amount of read bytes from read
Date:         28.09.2012
Changes:
******************************************************************************/
int ServerGetMsg(int* socket, char* buffer )
{
  int ret=0;
  int i;
  char tmp_buf[BUF]="\0";

  if(*socket == -1)
    return ret;     // socket not connected, don't read

  ret = read(*socket, tmp_buf, BUF);

  if (ret>0)
  { // got data
    for (i=0; i<ret; i++)
    {   //not terminated
      if ( tmp_buf[i]!='\r' )
      {
        if (tmp_buf[i]!=0x0A)
        {
          buffer[write_pos] = tmp_buf[i];
          write_pos++;
        }
      }
      else
      { // if terminated, give it to the RCDataHandler function
        buffer[write_pos] = 0x00;
        RCDataHandler(socket, buffer);
        memset(buffer, '\0',sizeof(buffer) );
        write_pos=0;
      }
        //prevents a too long and not terminated string
      if (write_pos >= BUF )
        write_pos = BUF-1;
    }
  }

  if( (ret == 0) && (*socket != -1))
  { // socket closed
    printf("%s: Socket disconnected\n", appl_name);
    *socket=-1;
  }

  return ret;
}
/******************************************************************************
Function:     ServerLookForConnections
Description:  checks with select, if there a new connection
Parameter:    socket:        ptr to listen socket
              client_socket: ptr to client socket
              fds:           ptr to set of fds
Return:       value of server socket
Date:         28.09.2012
Changes:
******************************************************************************/
int
ServerLookForConnections(int* server_socket, int* client_socket, fd_set* read_fd_set)
{
  int ret;
  struct timeval time10;
  struct sockaddr_in cli;
  socklen_t cli_size;
  cli_size = sizeof(cli);
  time10.tv_sec  = 0;
  time10.tv_usec = 500;
  long save_sock_opt;
  int tmp_socket;
  char str[100];

  // clear set of fds
  FD_ZERO(read_fd_set);
  FD_SET (*server_socket, read_fd_set);

  if (*client_socket>0)
    FD_SET(*client_socket, read_fd_set);

  ret = *server_socket;

  time10.tv_sec  = 0;
  time10.tv_usec = 5;

  select(FD_SETSIZE, read_fd_set, NULL, NULL, &time10);

  // is one set
  if (FD_ISSET(*server_socket, read_fd_set ))
  {
    // new connection
    tmp_socket = accept(*server_socket, 0,0); 
        
    if (*client_socket == -1 )
    { // socket is not in use, accept connection
      *client_socket = tmp_socket;
      ServerSendFirstMsg(client_socket);
      printf("%s: Socket connected\n", appl_name);

      // don't block on reading
      save_sock_opt=fcntl (*client_socket, F_GETFL, 0);
      save_sock_opt|=O_NONBLOCK;
      fcntl(*client_socket, F_SETFL, save_sock_opt);
    }
    else
    { // socket is busy, only one connection is accepted
      printf("%s: Error, socket is busy !!\n", appl_name);
      strcpy(str, "Error, socket is busy, close connection\r");
      write(tmp_socket, str, strlen(str));
      close(tmp_socket);
      FD_CLR (tmp_socket, read_fd_set);
    }
  }

  return ret;
}


// end of file
