/*******************************************************************************
*  (c) synertronixx GmbH
*  Lange Laube Str. 22
*  30159 Hannover
*  Tel. : 0511 / 262 999  0
*  Fax. : 0511 / 262 999 29
*  Web  : www.synertronixx.de
*  eMail: devilanapp@synertronixx.de
* ----------------------------
* Project       : DeviLAN App RC server  
* Name          : timebase.c
* Version       : see variable "appl_version_info"
* Date          : 28.09.2012
* Author        : DeviLAN app team
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* *****************************************************************************/

// Linux Header
#include <sys/time.h>



/******************************************************************************
Function:    TimeGetLag
Description: calculate the lag time between to times
Parameter:   t1:     ptr to time value 1
             t2:     ptr to time value 2 with t2>t1
             result: ptr to time lag buffer (t2-t1) 
Return:      1: the time lag was calculated correctly
             0: when an no day overflow occured
Date:        28.09.2012
Changes:    
******************************************************************************/
int
TimeGetLag(struct timeval* result, struct timeval* t1, struct timeval* t2)
{
  int ret_value=1;

  // calculate lag in seconds
  result->tv_sec = t2->tv_sec - t1->tv_sec;
  if(result->tv_sec<0)
  {
    ret_value = 0;
  }

  // calculate lag in micro-seconds
  if( t2->tv_usec >= t1->tv_usec)
    result->tv_usec = t2->tv_usec - t1->tv_usec;
  else
  { // second overflow occured
    result->tv_usec = t2->tv_usec - t1->tv_usec + 1000000; // correct usecond
    result->tv_sec--;                                      // correct second
  }

  return ret_value;
}

/******************************************************************************
Function:    TimeCompare
Description: check if time t2 is greater or equal then time t1
Parameter:   t1:     ptr to time value 1
             t2:     ptr to time value 2 
Return:      1: when t2>=t1 
             0: otherwise
Date:        28.09.2012
Changes:    
******************************************************************************/
int
TimeCompare(struct timeval* t1, struct timeval* t2)
{
  int ret_value=0;
  //struct timeval diff;

  if(t2->tv_sec > t1->tv_sec)
  { // seconds are larger so t2>t1
    ret_value=1;
  }
  else
  {
    if(t2->tv_sec == t1->tv_sec)
      if (t2->tv_usec >= t1->tv_usec)
        ret_value=1;
  }

  if(ret_value)
  { // set new compare value
    //TimeGetLag(&diff, t1, t2);
    //printf("Time: %6ld.%06ld   Jitter: %6ld.%06ld\n", t2->tv_sec, t2->tv_usec, diff.tv_sec, diff.tv_usec);
  }

  return ret_value;
}


/******************************************************************************
Function:    TimeSetTo
Description: set to time value t1 to time of value t2 + ms
Parameter:   t1:     ptr to time value 1
             t2:     ptr to time value 2 
             ms:     time offset in ms
             result is in t1
Return:      1: when addition was corecct 
             0: when overflow occured
Date:        28.09.2012
Changes:    
******************************************************************************/
int
TimeSetTo(struct timeval* t1, struct timeval* t2, long int ms)
{
  int carry=0;
  int ret_value=1;
  int usec;
  int sec;

  sec  = ms/1000;
  usec = ms%1000;

  t1->tv_usec = t2->tv_usec + (usec*1000);

  if(t1->tv_usec >= 1000000)
  { // seconds overflow
    t1->tv_usec -= 1000000;
    carry =1;
  }
  else
  {
    if(t1->tv_usec <0)
    { // else second underflow
      t1->tv_usec += 1000000;
      carry = -1;
    }
  }
  
  // calculate second
  t1->tv_sec = t2->tv_sec + sec + carry;

  return ret_value;
}



// end of file
