#Copyright Jon Berg , turtlemeat.com
#!/usr/bin/python
#*******************************************************************************
#  synertronixx GmbH
#  Lange Laube Str. 22
#  30159 Hannover
#  Tel. : 0511 / 262 999  0
#  Fax. : 0511 / 262 999 29
#  Web  : www.synertronixx.de
#  eMail: devilanapp@synertronixx.de
# ----------------------------
# Project       : Raspberry Pi Finder to use with iOS App DeviLAN 
# Name          : devilan_pi_simple_webserver.py
# IDLE          : version 2.7.3 , Python version 2.7.3 & Tk version 8.5                   
# Version       : 1.2
# Date          : 24.04.2014
# Author        : DeviLAN app team
# Description   :
#
# - This program allows to find Raspberry Pi modules in your LAN via an
#   UDP broadcast identification mechanism.
#
# - Use iOS App DeviLAN (TCP/IP based Remote Control tool) to find and control
#   Raspberry Pis which you can download for free from the Appstore
#   http://itunes.apple.com/us/app/devilan/id544777502?l=de&ls=1&mt=8#
#
# - Use Android App DeviLAN (TCP/IP based Remote Control tool) to find and control
#   Raspberry Pis which you can download for free from Google play
#   https://play.google.com/store/apps/details?id=com.synertronixx.devilan
#
# - Also use program devilan_pi_rc_server_piface.py as example to create your own Remote Control GUI
#   for iPhone, iPad and iPod to control Raspberry Pi and peripheral devices e.g. "Pi Face"
#
# - Get further information about DeviLAN app from our website:
#   http://www.synertronixx.de/produkte/devilanapp/DeviLANApp_search_configure.htm
#   http://www.synertronixx.de/produkte/devilanapp/DeviLANApp_remote_control.htm
#
# - Testing:
#   1. Copy this file to "/home/pi/DeviLAN_Pi_Servers/"
#   2. Start Python IDLE
#   3. Open this file
#   4. Run the script (F5)
#
# - Start script on power up (boot) automatically:
#   1. Open file  "/etc/rc.local" in editor
#      e.g.: "sudo nano /etc/rc.local"
#   2. Add line "python /home/pi/DeviLAN_Pi_Servers/devilan_pi_simple_webserver.py &
#      and store the file
#   3. Make file executable
#      e.g.: "chmod 755 /home/pi/DeviLAN_Pi_Servers/devilan_pi_simple_webserver.py
#
# - History:
#   24.03.2014: Released first beta version 
#   25.03.2014: Bugfix in path verification when script starts automatically
#   24.04.2014: New Google play links for Android App 
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
# *****************************************************************************/

# all imports
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer
from os import path
import sys


# Some global settings
APPNAME = "DeviLAN-Pi Simple Webserver 1.2: "   # Application name for debug output
WEBSERVER_PORT = 8080                           # Webserver communication port
WEB_DIR = "Webpages"                            # relative directory for all avaiable files (HMTL, images, etc.)
WEB_DIR_FULL = "/home/pi/DeviLAN_Pi_Servers/" + WEB_DIR # absolute Directory for all avaiable files (HMTL, images, etc.)


class WebserverHandler(BaseHTTPRequestHandler):

    def do_GET(self):

        # build filename
        filename = path.abspath(WEB_DIR_FULL + self.path)
        #filename = path.abspath(WEB_DIR_FULL + "/../" + self.path) # for test, create forbidden path

        print (APPNAME + "Filename '%s'" % filename)

        if (filename.find(WEB_DIR_FULL) != 0): # path did not start with WEB_DIR_FULL
            # try to leave web directory, security-risc, send error message
            print ((APPNAME + "Path error! Try to leave web directory '%s'") % filename)
            self.send_error(403,"Forbidden path: '%s'" % filename)
            return

        
        
        try:
            if (self.path.lower().endswith(".html") | self.path.lower().endswith(".htm") ): # Type htm, html
                f = open(filename) 
                self.send_response(200)
                self.send_header('Content-type',"text/html")
                self.end_headers()
                self.wfile.write(f.read())
                f.close()
                return

            if self.path.lower().endswith(".png"): # Type png
                f = open(filename)
                self.send_response(200)
                self.send_header("Content-type","image/png")
                self.end_headers()
                self.wfile.write(f.read())
                f.close()
                return

            if (self.path.lower().endswith(".jpg")| self.path.lower().endswith(".jpeg")): # Type jpg, jpeg
                f = open(filename)
                self.send_response(200)
                self.send_header("Content-type","image/JPEG")
                self.end_headers()
                self.wfile.write(f.read())
                f.close()
                return

            if self.path.lower().endswith(".gif"): # Type gif
                f = open(filename)
                self.send_response(200)
                self.send_header("Content-type","image/gif")
                self.end_headers()
                self.wfile.write(f.read())
                f.close()
                return

            if (self.path.lower().endswith(".m4a") | self.path.lower().endswith(".mp3")): # Type mp3,m4a (audio)
                f = open(filename)
                self.send_response(200)
                self.send_header("Content-type","application/octet-stream")
                self.end_headers()
                self.wfile.write(f.read())
                f.close()
                return
            
            # There are many other content types. Just add them when needed.
            # e.g.:
            #  ".class", "application/octet-stream"
            #  ".css",   "text/html"
            #  ".cgi",   "text/html"
            #  ".jsn",   "application/json"
            #  ".js",    "application/javascript"                         


        except IOError:
            print ((APPNAME + "File Not Found: '%s'") % filename)
            self.send_error(404,"File Not Found: '%s'" % (filename))
     


def main():
    try:
        print APPNAME + "Starting webserver..."
        server = HTTPServer(("", WEBSERVER_PORT), WebserverHandler)
        print (APPNAME + "Webserver started at port %d" % WEBSERVER_PORT)
        server.serve_forever()

    except KeyboardInterrupt:
        print APPNAME + "Received ctrl-c, shutting down server"
        server.socket.close()

    except Exception as e:
        print (APPNAME + "Exception : %s" % str(e) )
        sys.exit(1)

main()

# end of file

